
#ifndef MEETINGTELEMETRY_H
#define MEETINGTELEMETRY_H

#include "csfunified/framework/UnifiedFactory.h"

#include <string>
#include <list>

/*!
 * \class CMeetingTelemetry  
 *
 * \brief  meeting telemetry class will process of the telemetry data to server
 *
 * \author Jma
 * \date October 2015
 */
class CMeetingTelemetry
{
public:
	/*!
	* \function construct function
	*
	* \brief the object will use default UnifiedFactory.
	*/
	CMeetingTelemetry();
	/*!
	* \function construct function
	*
	* \brief the object will use pUrifiedFactory instance.
	*/
	CMeetingTelemetry(CSFUnified::UnifiedFactory *pUnifiedFactory);
	/*!
	* \function construct function
	*
	* \brief unifiedFactory will be overlay to default static member
	*/
	CMeetingTelemetry(SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> unifiedFactory);
	/*!
	* \function copy construct function
	*
	* \brief copy construct function of the CMeetingTelemetry
	*/
	CMeetingTelemetry(const CMeetingTelemetry &ins);
	/*!
	* \function copy destructor function
	*
	* \brief destructor function of the CMeetingTelemetry 
	*/
	virtual ~CMeetingTelemetry();
public:
	/*!
	* \function upload
	*
	* \brief the upload telemetry data to server. this is a synchronize process.
	*        rootName is a base identify
	*/
	bool upload(std::string rootName);
	/*!
	* \function addMember
	*
	* \brief add a member to telemetry group
	*        memberName is member name
	*		 memberValue is member value
	*/
	bool addMember(std::string memberName, std::string memberValue);
	/*!
	* \function delMember
	*
	* \brief remove of member from the telemetry group
	*        memberName is member name
	*/
	bool delMember(std::string memberName);
protected:
	std::list<std::pair<std::string, std::string> > mMembers;
	CSFUnified::UnifiedFactory *mpUnifiedFactory;
protected:
	static SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> UnifiedFactory;
};


#endif // MEETINGTELEMETRY_H